/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.mixin;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.regions_unexplored.block.RuBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrunkPlacer.class})
public abstract class TrunkPlacerDirtMixin {
    @Inject(at={@At(value="HEAD")}, method={"setDirtAt(Lnet/minecraft/world/level/LevelSimulatedReader;Ljava/util/function/BiConsumer;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/feature/configurations/TreeConfiguration;)V"})
    private static void setDirtAt(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> dirt, RandomSource random, BlockPos pos, TreeConfiguration configuration, CallbackInfo ci) {
        if (!((LevelReader)level).m_8055_(pos).onTreeGrow((LevelReader)level, dirt, random, pos, configuration) && TrunkPlacerDirtMixin.isForestGrass(level, pos)) {
            dirt.accept(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_());
        }
        if (!((LevelReader)level).m_8055_(pos).onTreeGrow((LevelReader)level, dirt, random, pos, configuration) && TrunkPlacerDirtMixin.isPlainsGrass(level, pos)) {
            dirt.accept(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_());
        }
        if (!((LevelReader)level).m_8055_(pos).onTreeGrow((LevelReader)level, dirt, random, pos, configuration) && TrunkPlacerDirtMixin.isAlphaGrass(level, pos)) {
            dirt.accept(pos, Blocks.f_50493_.m_49966_());
        }
    }

    private static boolean isForestGrass(LevelSimulatedReader p_70296_, BlockPos p_70297_) {
        return p_70296_.m_7433_(p_70297_, p_70304_ -> p_70304_.m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get()) || p_70304_.m_60713_((Block)RuBlocks.PEAT_DIRT.get()));
    }

    private static boolean isPlainsGrass(LevelSimulatedReader p_70296_, BlockPos p_70297_) {
        return p_70296_.m_7433_(p_70297_, p_70304_ -> p_70304_.m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get()) || p_70304_.m_60713_((Block)RuBlocks.SILT_DIRT.get()));
    }

    private static boolean isAlphaGrass(LevelSimulatedReader p_70296_, BlockPos p_70297_) {
        return p_70296_.m_7433_(p_70297_, p_70304_ -> p_70304_.m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get()) || p_70304_.m_60713_(Blocks.f_50493_));
    }
}

