/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class HoseItem
extends Item {
    public static final int NO_ASSIGN = 0;
    public static final int SUCK_MODE = 1;
    public static final int SPILL_MODE = 2;
    public static final int DRINK_MODE = 3;

    public HoseItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (HoseItem.getHoseMode(stack) == 3) {
            return UseAnim.DRINK;
        }
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack pStack) {
        return 24;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41782_()) {
            this.setCompoundTag(stack);
        }
        if (CapabilityUtils.isWearingBackpack(player) && hand == InteractionHand.MAIN_HAND) {
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper(player, CapabilityUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            if (HoseItem.getHoseMode(stack) == 1) {
                BlockState blockstate1;
                Block block;
                BlockHitResult result = HoseItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
                BlockPos blockpos = result.m_82425_();
                Direction direction1 = result.m_82434_();
                BlockPos blockpos1 = blockpos.m_121945_(result.m_82434_());
                if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction1, stack) && (block = (blockstate1 = level.m_8055_(blockpos)).m_60734_()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    Fluid fluid = blockstate1.m_60819_().m_76152_();
                    if (fluid != Fluids.f_76191_) {
                        ItemStack actualFluid;
                        boolean canFill;
                        FluidStack fluidStack = new FluidStack(fluid, 1000);
                        int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                        boolean bl = canFill = tank.isEmpty() || FluidStack.areFluidStackTagsEqual((FluidStack)tank.getFluid(), (FluidStack)fluidStack);
                        if (canFill && fluidStack.getAmount() + tankAmount <= tank.getCapacity() && !(actualFluid = pickup.m_142598_((LevelAccessor)level, blockpos, blockstate1)).m_41619_()) {
                            level.m_5594_(player, result.m_82425_(), fluidStack.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL) == null ? (fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11783_ : SoundEvents.f_11781_) : fluidStack.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL), SoundSource.BLOCKS, 1.0f, 1.0f);
                            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                            return InteractionResultHolder.m_19090_((Object)stack);
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 2 && tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get()) {
                ItemStack potionStack;
                if (tank.getFluid().getOrCreateTag().m_128441_("Splash") && tank.getFluidAmount() >= 250) {
                    potionStack = FluidStackHelper.getSplashItemStackFromFluidStack(tank.getFluid());
                    int drainAmount = ServerActions.throwPotion(level, player, potionStack, true);
                    tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                if (tank.getFluid().getOrCreateTag().m_128441_("Lingering") && tank.getFluidAmount() >= 250) {
                    potionStack = FluidStackHelper.getLingeringItemStackFromFluidStack(tank.getFluid());
                    int drainAmount = ServerActions.throwPotion(level, player, potionStack, false);
                    tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            }
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && EffectFluidRegistry.hasExecutableEffects(tank.getFluid(), level, (Entity)player)) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        ItemStack stack = player.m_21120_(context.m_43724_());
        if (!stack.m_41782_()) {
            this.setCompoundTag(stack);
        }
        if (CapabilityUtils.isWearingBackpack(player) && context.m_43724_() == InteractionHand.MAIN_HAND) {
            FluidStack fluidStack;
            FluidStack fluidStack2;
            LazyOptional fluidHandler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)direction);
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper(player, CapabilityUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return InteractionResult.PASS;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            if (HoseItem.getHoseMode(stack) == 1) {
                BlockState blockstate1;
                Block block;
                if (fluidHandler.isPresent() && !((Boolean)fluidHandler.map(h -> h.getFluidInTank(0).isEmpty()).get()).booleanValue() && !(fluidStack2 = FluidUtil.tryFluidTransfer((IFluidHandler)tank, (IFluidHandler)((IFluidHandler)fluidHandler.orElse(null)), (int)1000, (boolean)true)).isEmpty()) {
                    level.m_5594_(player, pos, fluidStack2.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL), SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                BlockHitResult result = HoseItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
                BlockPos blockpos = result.m_82425_();
                Direction direction1 = result.m_82434_();
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction1, stack) && (block = (blockstate1 = level.m_8055_(blockpos)).m_60734_()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    Fluid fluid = blockstate1.m_60819_().m_76152_();
                    if (fluid != Fluids.f_76191_) {
                        ItemStack actualFluid;
                        boolean canFill;
                        fluidStack = new FluidStack(fluid, 1000);
                        int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                        boolean bl = canFill = tank.isEmpty() || FluidStack.areFluidStackTagsEqual((FluidStack)tank.getFluid(), (FluidStack)fluidStack);
                        if (canFill && fluidStack.getAmount() + tankAmount <= tank.getCapacity() && !(actualFluid = pickup.m_142598_((LevelAccessor)level, blockpos, blockstate1)).m_41619_()) {
                            level.m_5594_(player, result.m_82425_(), fluidStack.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL) == null ? (fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11783_ : SoundEvents.f_11781_) : fluidStack.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL), SoundSource.BLOCKS, 1.0f, 1.0f);
                            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 2) {
                if (fluidHandler.isPresent() && !tank.isEmpty() && !(fluidStack2 = FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)fluidHandler.orElse(null)), (IFluidHandler)tank, (int)1000, (boolean)true)).isEmpty()) {
                    level.m_5594_(player, pos, fluidStack2.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL), SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get()) {
                    ItemStack potionStack;
                    if (tank.getFluid().getOrCreateTag().m_128441_("Splash") && tank.getFluidAmount() >= 250) {
                        potionStack = FluidStackHelper.getSplashItemStackFromFluidStack(tank.getFluid());
                        int drainAmount = ServerActions.throwPotion(level, player, potionStack, true);
                        tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                        return InteractionResult.SUCCESS;
                    }
                    if (tank.getFluid().getOrCreateTag().m_128441_("Lingering") && tank.getFluidAmount() >= 250) {
                        potionStack = FluidStackHelper.getLingeringItemStackFromFluidStack(tank.getFluid());
                        int drainAmount = ServerActions.throwPotion(level, player, potionStack, false);
                        tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                        return InteractionResult.SUCCESS;
                    }
                }
                if (!tank.isEmpty()) {
                    BlockState blockState = level.m_8055_(pos);
                    Block block = blockState.m_60734_();
                    Fluid fluid = tank.getFluid().getFluid();
                    if (tank.getFluidAmount() >= 1000 && fluid instanceof FlowingFluid) {
                        LiquidBlockContainer container;
                        FlowingFluid flowingFluid = (FlowingFluid)fluid;
                        if (block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockState, fluid)) {
                            container.m_7361_((LevelAccessor)level, pos, blockState, flowingFluid.m_76068_(false));
                            level.m_5594_(player, pos, fluid.getFluidType().getSound(SoundActions.BUCKET_EMPTY), SoundSource.BLOCKS, 1.0f, 1.0f);
                            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            return InteractionResult.SUCCESS;
                        }
                    }
                    int x = pos.m_123341_();
                    int y = pos.m_123342_();
                    int z = pos.m_123343_();
                    if (!level.m_8055_(pos).m_60722_(fluid)) {
                        switch (context.m_43719_()) {
                            case WEST: {
                                --x;
                                break;
                            }
                            case EAST: {
                                ++x;
                                break;
                            }
                            case NORTH: {
                                --z;
                                break;
                            }
                            case SOUTH: {
                                ++z;
                                break;
                            }
                            case UP: {
                                ++y;
                                break;
                            }
                            case DOWN: {
                                --y;
                                break;
                            }
                        }
                    }
                    BlockPos newPos = new BlockPos(x, y, z);
                    fluidStack = tank.getFluid();
                    if (level.m_8055_(newPos).m_60722_(fluid) && fluid.getFluidType().canBePlacedInLevel((BlockAndTintGetter)level, newPos, fluidStack)) {
                        boolean flag;
                        boolean bl = flag = !level.m_8055_(newPos).m_280296_();
                        if (level.m_6042_().f_63857_() && fluidStack.getFluid().m_205067_(FluidTags.f_13131_)) {
                            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            level.m_5594_(null, newPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.8f);
                            for (int i = 0; i < 3; ++i) {
                                double d0 = (double)newPos.m_123341_() + level.m_213780_().m_188500_();
                                double d1 = (double)newPos.m_123342_() + level.m_213780_().m_188500_() * 0.5 + 0.5;
                                double d2 = (double)newPos.m_123343_() + level.m_213780_().m_188500_();
                                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0, d1, d2, 0.0, 0.0, 0.0);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (fluidStack.getAmount() >= 1000) {
                            if (!level.f_46443_ && flag && !level.m_8055_(newPos).m_278721_()) {
                                level.m_46961_(newPos, false);
                            }
                            if (level.m_7731_(newPos, fluidStack.getFluid().m_76145_().m_76188_(), 3)) {
                                level.m_5594_(player, newPos, fluidStack.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY), SoundSource.BLOCKS, 1.0f, 1.0f);
                                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                                level.m_46672_(newPos, fluidStack.getFluid().m_76145_().m_76188_().m_60734_());
                            }
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && EffectFluidRegistry.hasExecutableEffects(tank.getFluid(), level, (Entity)player)) {
                player.m_6672_(context.m_43724_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player;
        if (entityLiving instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)entityLiving)) {
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper(player, CapabilityUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return stack;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            if (HoseItem.getHoseMode(stack) == 3 && tank != null && ServerActions.setFluidEffect(level, player, tank)) {
                int drainAmount = EffectFluidRegistry.getHighestFluidEffectAmount(tank.getFluid().getFluid());
                tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return stack;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (CapabilityUtils.isWearingBackpack(player) && hand == InteractionHand.MAIN_HAND && HoseItem.getHoseMode(stack) == 1) {
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper(player, CapabilityUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return InteractionResult.PASS;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            Fluid milk = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation("minecraft", "milk"));
            if (milk != null && entity instanceof Cow) {
                int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                FluidStack milkStack = new FluidStack(milk, 1000);
                if (milkStack.getFluid() != Fluids.f_76191_ && (tank.isEmpty() || FluidStack.areFluidStackTagsEqual((FluidStack)tank.getFluid(), (FluidStack)milkStack)) && milkStack.getAmount() + tankAmount <= tank.getCapacity()) {
                    tank.fill(milkStack, IFluidHandler.FluidAction.EXECUTE);
                    player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static int getHoseMode(ItemStack stack) {
        if (NbtHelper.has(stack, "HoseModes")) {
            return (Integer)((List)NbtHelper.get(stack, "HoseModes")).get(0);
        }
        return 0;
    }

    public static int getHoseTank(ItemStack stack) {
        if (NbtHelper.has(stack, "HoseModes")) {
            return (Integer)((List)NbtHelper.get(stack, "HoseModes")).get(1);
        }
        return 0;
    }

    public FluidTank getSelectedFluidTank(ItemStack stack, TanksUpgrade upgrade) {
        return HoseItem.getHoseTank(stack) == 1 ? upgrade.getLeftTank() : upgrade.getRightTank();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (NbtHelper.has(stack, "HoseModes")) {
            int tank;
            int mode = (Integer)((List)NbtHelper.get(stack, "HoseModes")).get(0);
            if (mode == 1) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.travelersbackpack.hose.suck").m_130940_(ChatFormatting.BLUE));
            }
            if (mode == 2) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.travelersbackpack.hose.spill").m_130940_(ChatFormatting.BLUE));
            }
            if (mode == 3) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.travelersbackpack.hose.drink").m_130940_(ChatFormatting.BLUE));
            }
            if ((tank = ((Integer)((List)NbtHelper.get(stack, "HoseModes")).get(1)).intValue()) == 1) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.travelersbackpack.hose.tank_left").m_130940_(ChatFormatting.BLUE));
            }
            if (tank == 2) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.travelersbackpack.hose.tank_right").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public void setCompoundTag(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("HoseModes")) {
            NbtHelper.set(stack, "HoseModes", List.of(Integer.valueOf(1), Integer.valueOf(1)));
        }
    }
}

