/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.config.RoundedRockConfig;

public class RoundedRock
extends Feature<RoundedRockConfig> {
    public RoundedRock(Codec<RoundedRockConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RoundedRockConfig> context) {
        RandomSource random = context.m_225041_();
        ImprovedNoise improvedNoise = new ImprovedNoise(random);
        RoundedRockConfig config = (RoundedRockConfig)context.m_159778_();
        BlockPos origin = context.m_159777_();
        int rawRadius = config.radius().m_214085_(random);
        int height = config.height().m_214085_(random);
        float frequency = config.noiseFrequency().m_214084_(random);
        BlendingFunction blendingFunction = (BlendingFunction)config.blendFunction().m_216820_(random).orElseThrow();
        LongOpenHashSet cached = new LongOpenHashSet();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = -5; y < height; ++y) {
            double yDelta = 1.0 - (double)y / (double)height;
            if (yDelta >= 0.0 && yDelta <= 1.0) {
                yDelta = blendingFunction.apply(yDelta);
            }
            double radius = (double)rawRadius * yDelta;
            for (double x = -radius; x <= radius; x += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    mutableBlockPos.m_122154_((Vec3i)origin, (int)x, y, (int)z);
                    if (!mutableBlockPos.m_123314_((Vec3i)origin.m_175288_(mutableBlockPos.m_123342_()), radius)) continue;
                    double normalizedNoise = (improvedNoise.m_164308_((double)((float)mutableBlockPos.m_123341_() * frequency), (double)((float)mutableBlockPos.m_123342_() * frequency), (double)((float)mutableBlockPos.m_123343_() * frequency)) + 1.0) * 0.5;
                    double localRadius = Mth.m_14085_((double)(radius * 0.5), (double)radius, (double)normalizedNoise);
                    if (!mutableBlockPos.m_123314_((Vec3i)origin.m_175288_(mutableBlockPos.m_123342_()), localRadius)) continue;
                    cached.add(mutableBlockPos.m_121878_());
                }
            }
        }
        for (Pair<BlockPredicate, BlockStateProvider> blockPlacement : config.checkedBlockPlacement().blockPlacement()) {
            cached.forEach(pos -> {
                mutableBlockPos.m_122188_(pos);
                if (((BlockPredicate)blockPlacement.getFirst()).test((Object)context.m_159774_(), (Object)mutableBlockPos)) {
                    context.m_159774_().m_7731_((BlockPos)mutableBlockPos, ((BlockStateProvider)blockPlacement.getSecond()).m_213972_(random, (BlockPos)mutableBlockPos), 2);
                }
            });
        }
        return true;
    }

    public static double easeInCirc(double x) {
        return 1.0 - Math.sqrt(1.0 - Math.pow(x, 1.1));
    }
}

