# Panel API

Service Express que expone la API y la SPA del panel administrativo del bot. Incluye Socket.IO para métricas en tiempo real, autenticación basada en cuentas propias del panel y la posibilidad de vincular cada usuario con su cuenta de Discord.

## Configuración

1. Copia `.env.example` a `.env` y define tus variables (credenciales de base de datos, secretos JWT y claves OAuth de Discord).
2. Instala dependencias con `npm install`.
3. Inicia el servidor en desarrollo con `npm run dev` o en producción con `npm start`.

La API escucha en el puerto indicado por la variable `PORT` (3001 por defecto). Si despliegas el panel bajo una subruta establece `PUBLIC_BASE_PATH` para que tanto Express como la SPA generen URLs correctas.

## Autenticación

- El acceso al panel se realiza con cuentas nativas almacenadas en la tabla `panel_accounts`. Las contraseñas se guardan con bcrypt y se validan mediante `POST /api/auth/login`, que genera un JWT y lo envía en la cookie `auth`.
- Una vez iniciada la sesión puedes vincular la cuenta de Discord pulsando en **Conectar Discord**. El flujo OAuth (`/auth/discord/login` → `/auth/discord/callback`) guarda el `discordId` en la cuenta del panel y actualiza la sesión existente; ya no es posible acceder únicamente con OAuth de Discord.
- El botón de desconexión cierra la sesión invocando `POST /api/auth/logout`, que limpia la cookie.

## Administración

- Los usuarios con rol `admin` o `superadmin` pueden abrir el modal de administración para crear cuentas, restablecer contraseñas y ajustar permisos por rol.
- Los permisos efectivos se guardan en `panel_role_permissions` y se combinan con los predeterminados definidos en `src/utils/permissions.js`.

## Semilla del primer superadmin

Para poder usar el panel por primera vez necesitas crear una cuenta manualmente. Desde cualquier máquina con Node.js y las dependencias instaladas puedes obtener un hash seguro ejecutando:

```bash
node -e "import('bcryptjs').then(({default: b}) => b.hash('tuPassword', 12).then(h => console.log(h)))"
```

Después inserta el usuario en MySQL (ajusta código, usuario y timestamps según tus necesidades):

```sql
INSERT INTO panel_accounts (accountCode, username, password_hash, role, avatarUrl, discordId, createdAt, updatedAt)
VALUES ('ADMIN01', 'superadmin', '$2a$12$XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX', 'superadmin', NULL, NULL, UNIX_TIMESTAMP()*1000, UNIX_TIMESTAMP()*1000);
```

Con esa cuenta podrás iniciar sesión en el panel, crear más usuarios desde la pestaña **Usuarios** y gestionar permisos desde **Permisos**.

## Verificación y mantenimiento

- Todas las rutas bajo `/api` validan exclusivamente sesiones de cuentas del panel y devuelven `401` si la cookie pertenece a un flujo antiguo de Discord.
- Los middlewares de permisos se alimentan ahora del rol almacenado en la cuenta del panel, por lo que no dependen de la tabla histórica de `user_ranks` para conceder acceso.
- Antes de desplegar revisa los registros del servidor tras el arranque (`npm run dev`) y realiza un login/logout manual para confirmar que la cookie `auth` se emite y se limpia correctamente.
