import jwt from 'jsonwebtoken';

/**
 * Signs a JWT with the given payload using the application's secret.
 * The token expires in 7 days.
 *
 * @param {Object} payload
 * @returns {string}
 */
export function signJwt(payload) {
  return jwt.sign(payload, process.env.JWT_SECRET, { expiresIn: '7d' });
}

/**
 * Verifies a JWT and returns the decoded payload or null if invalid.
 *
 * @param {string} token
 * @returns {Object|null}
 */
export function verifyJwt(token) {
  try {
    return jwt.verify(token, process.env.JWT_SECRET);
  } catch {
    return null;
  }
}