import { isStaff, isMod, isAdmin } from '../utils/permisosBridge.js';
const { SINGLE_GUILD_ID = null } = process.env;

/**
 * Ensures the requester has at least the Staff role for the specified guild.
 */
export async function requireStaff(req, res, next) {
  const guildId = SINGLE_GUILD_ID || req.header('x-guild-id') || req.query.guildId || req.body.guildId || null;
  try {
    const ok = await isStaff(req.user, guildId);
    if (!ok) return res.status(403).json({ error: 'Need Staff' });
    next();
  } catch (err) {
    next(err);
  }
}

/**
 * Ensures the requester has at least the Mod role for the specified guild.
 */
export async function requireMod(req, res, next) {
  const guildId = SINGLE_GUILD_ID || req.header('x-guild-id') || req.query.guildId || req.body.guildId || null;
  try {
    const ok = await isMod(req.user, guildId);
    if (!ok) return res.status(403).json({ error: 'Need Mod' });
    next();
  } catch (err) {
    next(err);
  }
}

/**
 * Ensures the requester has the Admin role for the specified guild.
 */
export async function requireAdmin(req, res, next) {
  const guildId = SINGLE_GUILD_ID || req.header('x-guild-id') || req.query.guildId || req.body.guildId || null;
  try {
    const ok = await isAdmin(req.user, guildId);
    if (!ok) return res.status(403).json({ error: 'Need Admin' });
    next();
  } catch (err) {
    next(err);
  }
}
