import { Router } from 'express';
import { requireAuth } from '../middlewares/requireAuth.js';
import { requireStaff } from '../middlewares/requireRole.js';
import { query } from '../utils/db.js';
const { SINGLE_GUILD_ID = null } = process.env;

const r = Router();

// Returns some example key performance indicators for the dashboard
r.get('/', requireAuth, requireStaff, async (req, res) => {
  try {
    const now = Date.now();
    const since = now - 24 * 60 * 60 * 1000;

    const paramsUsers = [];
    const usersWhere = SINGLE_GUILD_ID ? 'WHERE guildId = ?' : '';
    if (SINGLE_GUILD_ID) paramsUsers.push(SINGLE_GUILD_ID);
    const [usersRow] = await query(`SELECT COUNT(DISTINCT userId) AS userCount FROM detailed_logs ${usersWhere}`,
      paramsUsers);

    const paramsEvents = [since];
    const eventsWhere = SINGLE_GUILD_ID ? 'WHERE guildId = ? AND timestamp >= ?' : 'WHERE timestamp >= ?';
    if (SINGLE_GUILD_ID) paramsEvents.unshift(SINGLE_GUILD_ID);
    const [eventsRow] = await query(`SELECT COUNT(*) AS eventCount FROM detailed_logs ${eventsWhere}`,
      paramsEvents);

    const paramsErrors = [since];
    const errorsWhere = SINGLE_GUILD_ID
      ? 'WHERE guildId = ? AND timestamp >= ? AND JSON_EXTRACT(details, "$.severity") = "error"'
      : 'WHERE timestamp >= ? AND JSON_EXTRACT(details, "$.severity") = "error"';
    if (SINGLE_GUILD_ID) paramsErrors.unshift(SINGLE_GUILD_ID);
    const [errorsRow] = await query(`SELECT COUNT(*) AS errorCount FROM detailed_logs ${errorsWhere}`,
      paramsErrors);

    res.json({
      events24h: eventsRow?.eventCount ?? 0,
      users: usersRow?.userCount ?? 0,
      ticketsOpen: 0,
      errors24h: errorsRow?.errorCount ?? 0,
    });
  } catch (err) {
    console.error('[kpis] Error computing KPIs:', err);
    res.status(500).json({ error: 'failed_to_compute_kpis' });
  }
});

export default r;
