import { Router } from 'express';
import { requireAuth } from '../middlewares/requireAuth.js';
import { get, getRolePermissions } from '../utils/db.js';
import { resolveRolePermissions } from '../utils/permissions.js';

const r = Router();

function mapPanelAccount(account, extra = {}) {
  if (!account) return null;
  return {
    id: account.id,
    accountId: account.id,
    accountCode: account.accountCode || null,
    username: account.username,
    role: account.role,
    rank: account.role,
    avatar: account.avatarUrl || null,
    avatarUrl: account.avatarUrl || null,
    discordId: account.discordId || null,
    createdAt: account.createdAt || null,
    updatedAt: account.updatedAt || null,
    type: 'panel',
    ...extra,
  };
}

r.get('/', requireAuth, async (req, res) => {
  const account = req.panelAccount;
  if (!account) {
    return res.status(401).json({ error: 'unauthorized' });
  }

  let discordRoleName = null;
  let discordRoleColor = null;
  if (account.discordId) {
    try {
      const row = await get('SELECT discordRoleName, discordRoleColor FROM panel_users WHERE discordId = ? LIMIT 1', [account.discordId]);
      discordRoleName = row?.discordRoleName || null;
      discordRoleColor = row?.discordRoleColor || null;
    } catch {}
  }

  let permissions = {};
  try {
    const rolePerms = await getRolePermissions(account.role);
    permissions = resolveRolePermissions(account.role, rolePerms?.permissions || {});
  } catch {
    permissions = resolveRolePermissions(account.role);
  }

  const user = mapPanelAccount(account, { discordRoleName, discordRoleColor, permissions });
  res.json({ user });
});

export default r;
