// panel/src/routes/ranks.js
import { Router } from 'express';
import { requireAuth } from '../middlewares/requireAuth.js';
import { requireAdmin } from '../middlewares/requireRole.js';
import { getUserRank, setUserRank, query } from '../utils/db.js';

const r = Router();

// Ver lista de rangos
r.get('/', requireAuth, requireAdmin, async (req,res) => {
  const rows = await query('SELECT userId, guildId, `rank` AS rank FROM user_ranks ORDER BY `rank` DESC');
  res.json(rows);
});

// Establecer rango a un usuario
r.post('/:userId', requireAuth, requireAdmin, async (req,res) => {
  const { userId } = req.params;
  const { guildId = null, rank } = req.body;
  if (!['staff','mod','admin','superadmin'].includes(rank)) return res.status(400).json({error:'invalid_rank'});
  await setUserRank(userId, guildId, rank);
  res.json({ ok:true });
});

export default r;

// Lista de usuarios del panel (para selector), con panelId y nombre
r.get('/users', requireAuth, requireAdmin, async (req, res) => {
  try {
    const rows = await query(
      `SELECT pu.discordId, pu.panelId, pu.username,
              (SELECT \`rank\` FROM user_ranks ur WHERE ur.userId = pu.discordId ORDER BY ur.guildId DESC LIMIT 1) AS rank
         FROM panel_users pu
        ORDER BY (pu.username IS NULL), pu.username, pu.panelId`
    );
    res.json(rows.map(r => ({
      discordId: r.discordId,
      panelId: r.panelId,
      username: r.username || null,
      rank: r.rank || null,
    })));
  } catch (e) {
    console.error('[ranks] list users error:', e);
    res.status(500).json([]);
  }
});
