import { Router } from 'express';
import { getStatusSnapshot } from '../live/socket.js';
import { requireAuth } from '../middlewares/requireAuth.js';

const r = Router();

r.get('/', requireAuth, (req, res) => {
  const snap = getStatusSnapshot();
  res.json({
    ok: true,
    ts: snap.ts || 0,
    metrics: snap.data || null,
  });
});

export default r;

