import { Router } from 'express';
import { requireAuth } from '../middlewares/requireAuth.js';
import { requireStaff } from '../middlewares/requireRole.js';
import { query } from '../utils/db.js';

const r = Router();

// Returns a list of open tickets (synced from bot via Socket.IO)
r.get('/', requireAuth, requireStaff, async (req, res) => {
  try {
    const rows = await query(
      `SELECT channelId, guildId, openerId, staffId, category, status, createdAt, updatedAt
       FROM tickets WHERE status = 'open' ORDER BY (createdAt IS NULL), createdAt DESC, updatedAt DESC`
    );
    const result = rows.map(r => ({
      id: r.channelId,
      userId: r.openerId,
      assignedId: r.staffId,
      category: r.category,
      status: r.status,
      createdAt: r.createdAt,
      updatedAt: r.updatedAt,
    }));
    res.json(result);
  } catch (err) {
    console.error('[tickets] Error listing tickets:', err);
    res.status(500).json({ error: 'failed_to_list_tickets' });
  }
});

// Solicitar sincronización manual de tickets al bot
r.post('/sync', requireAuth, requireStaff, async (req, res) => {
  try {
    const actor = req.user?.discordId || req.user?.accountCode || String(req.user?.id || '');
    const ok = global.emitToBot?.('tickets:sync', {
      by: actor,
      accountId: req.user?.accountId || req.user?.id || null,
      accountCode: req.user?.accountCode || null,
      discordId: req.user?.discordId || null,
      username: req.user?.username || null,
    });
    res.json({ ok: !!ok });
  } catch (e) {
    console.error('[tickets] sync error:', e);
    res.status(500).json({ ok: false });
  }
});

export default r;
