/**
 * Middleware to enforce a sudo-like confirmation step for sensitive actions.
 * Expects headers `x-sudo-code` and `x-sudo-ok`=1 to be present. If missing,
 * returns status 428 (Precondition Required). In production you would
 * implement a proper challenge/response flow.
 */
export function requireSudo(req, res, next) {
  const ok = req.header('x-sudo-code') && req.header('x-sudo-ok') === '1';
  if (!ok) return res.status(428).json({ error: 'SUDO_REQUIRED' });
  next();
}