// /var/www/html/panel/src/utils/permisosBridge.js
import { getUserRank } from '../utils/db.js';

async function resolveRank(user, guildId) {
  if (!user) return null;
  if (user.type === 'panel') {
    return user.role || user.rank || null;
  }
  return getUserRank(user.id, guildId);
}

export async function isStaff(user, guildId) {
  const rank = await resolveRank(user, guildId);
  return ['staff', 'mod', 'admin', 'superadmin'].includes((rank || '').toLowerCase());
}

export async function isMod(user, guildId) {
  const rank = await resolveRank(user, guildId);
  return ['mod', 'admin', 'superadmin'].includes((rank || '').toLowerCase());
}

export async function isAdmin(user, guildId) {
  const rank = await resolveRank(user, guildId);
  return ['admin', 'superadmin'].includes((rank || '').toLowerCase());
}

export async function isSuperAdmin(user, guildId) {
  const rank = await resolveRank(user, guildId);
  return (rank || '').toLowerCase() === 'superadmin';
}
