export const DEFAULT_ROLE_PERMISSIONS = {
  superadmin: {
    viewPanel: true,
    viewTickets: true,
    viewLogs: true,
    viewCommands: true,
    viewConfig: true,
    manageUsers: true,
    manageRoles: true,
  },
  admin: {
    viewPanel: true,
    viewTickets: true,
    viewLogs: true,
    viewCommands: true,
    viewConfig: true,
    manageUsers: true,
    manageRoles: true,
  },
  staff: {
    viewPanel: true,
    viewTickets: true,
    viewLogs: true,
    viewCommands: false,
    viewConfig: false,
    manageUsers: false,
    manageRoles: false,
  },
  mod: {
    viewPanel: true,
    viewTickets: true,
    viewLogs: false,
    viewCommands: false,
    viewConfig: false,
    manageUsers: false,
    manageRoles: false,
  },
  viewer: {
    viewPanel: true,
    viewTickets: false,
    viewLogs: false,
    viewCommands: false,
    viewConfig: false,
    manageUsers: false,
    manageRoles: false,
  },
};

export function resolveRolePermissions(role, stored = {}) {
  const base = DEFAULT_ROLE_PERMISSIONS[String(role).toLowerCase()] || {};
  return { ...base, ...(stored || {}) };
}
